/*
  ==============================================================================

  This is an automatically generated GUI class created by the Introjucer!

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Created with Introjucer version: 3.1.0

  ------------------------------------------------------------------------------

  The Introjucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-13 by Raw Material Software Ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...

#include "Patcher.h"

//[/Headers]

#include "SendPortComponent.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
SendPortComponent::SendPortComponent (const String& game, const String& address, const String& port)
{
    addAndMakeVisible (gameLabel = new Label ("gameLabel",
                                              "Game Name"));
    gameLabel->setFont (Font (15.00f, Font::bold));
    gameLabel->setJustificationType (Justification::centred);
    gameLabel->setEditable (true, true, false);
    gameLabel->setColour (TextEditor::textColourId, Colours::black);
    gameLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));
    gameLabel->addListener (this);

    addAndMakeVisible (addressLabel = new Label ("addressLabel",
                                                 "127.0.0.1"));
    addressLabel->setFont (Font (15.00f, Font::plain));
    addressLabel->setJustificationType (Justification::centred);
    addressLabel->setEditable (true, true, false);
    addressLabel->setColour (TextEditor::textColourId, Colours::black);
    addressLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));
    addressLabel->addListener (this);

    addAndMakeVisible (portLabel = new Label ("portLabel",
                                              "5679"));
    portLabel->setFont (Font (15.00f, Font::plain));
    portLabel->setJustificationType (Justification::centred);
    portLabel->setEditable (true, true, false);
    portLabel->setColour (TextEditor::textColourId, Colours::black);
    portLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));
    portLabel->addListener (this);


    //[UserPreSize]

	gameLabel->setText(game, dontSendNotification);
	addressLabel->setText(address, dontSendNotification);
	portLabel->setText(port, dontSendNotification);

    //[/UserPreSize]

    setSize (140, 64);


    //[Constructor] You can add your own custom stuff here..
    //[/Constructor]
}

SendPortComponent::~SendPortComponent()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    gameLabel = nullptr;
    addressLabel = nullptr;
    portLabel = nullptr;


    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void SendPortComponent::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.setColour (Colour (0xff9696c1));
    g.fillEllipse (1.0f, 20.0f, 24.0f, 24.0f);

    g.setColour (Colour (0xffb0b0ff));
    g.drawEllipse (1.0f, 20.0f, 24.0f, 24.0f, 2.000f);

    g.setColour (Colour (0xffeeece1));
    g.fillRoundedRectangle (13.0f, 1.0f, 126.0f, 62.0f, 10.000f);

    g.setColour (Colour (0xffb0b0ff));
    g.drawRoundedRectangle (13.0f, 1.0f, 126.0f, 62.0f, 10.000f, 2.000f);

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void SendPortComponent::resized()
{
    gameLabel->setBounds (12, 0, 128, 24);
    addressLabel->setBounds (12, 20, 128, 24);
    portLabel->setBounds (12, 40, 128, 24);
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void SendPortComponent::labelTextChanged (Label* labelThatHasChanged)
{
    //[UserlabelTextChanged_Pre]
    //[/UserlabelTextChanged_Pre]

    if (labelThatHasChanged == gameLabel)
    {
        //[UserLabelCode_gameLabel] -- add your label text handling code here..
		sendChangeMessage();
        //[/UserLabelCode_gameLabel]
    }
    else if (labelThatHasChanged == addressLabel)
    {
        //[UserLabelCode_addressLabel] -- add your label text handling code here..
		sendChangeMessage();
        //[/UserLabelCode_addressLabel]
    }
    else if (labelThatHasChanged == portLabel)
    {
        //[UserLabelCode_portLabel] -- add your label text handling code here..
		sendChangeMessage();
        //[/UserLabelCode_portLabel]
    }

    //[UserlabelTextChanged_Post]
    //[/UserlabelTextChanged_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...

//------------------------------------------------------------------------------
void SendPortComponent::mouseDown(const MouseEvent& event)
{
	if((event.x < 12) && ((event.y > 20) && (event.y < 44)))
	{
        Patcher *patcher(dynamic_cast<Patcher *>(getParentComponent()));

        if(patcher)
	    {
			patcher->removeConnection(this);
	    }
	}
}

//------------------------------------------------------------------------------
void SendPortComponent::mouseUp(const MouseEvent& event)
{
	Patcher *patcher(dynamic_cast<Patcher *>(getParentComponent()));

    if(patcher)
	{
		Point<int> parentPoint(getPosition().x + event.x,
							   getPosition().y + event.y);

		patcher->endNewConnection(parentPoint);
	}
}

//------------------------------------------------------------------------------
void SendPortComponent::mouseDrag(const MouseEvent& event)
{
	Patcher *patcher(dynamic_cast<Patcher *>(getParentComponent()));

    if(patcher)
	{
		Point<int> parentPoint(getPosition().x + event.x,
							   getPosition().y + event.y);

		patcher->dragNewConnection(parentPoint);
	}
}

//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Introjucer information section --

    This is where the Introjucer stores the metadata that describe this GUI layout, so
    make changes in here at your peril!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="SendPortComponent" componentName=""
                 parentClasses="public Component, public ChangeBroadcaster" constructorParams="const String&amp; game, const String&amp; address, const String&amp; port"
                 variableInitialisers="" snapPixels="8" snapActive="1" snapShown="1"
                 overlayOpacity="0.330000013" fixedSize="1" initialWidth="140"
                 initialHeight="64">
  <BACKGROUND backgroundColour="ffffff">
    <ELLIPSE pos="1 20 24 24" fill="solid: ff9696c1" hasStroke="1" stroke="2, mitered, butt"
             strokeColour="solid: ffb0b0ff"/>
    <ROUNDRECT pos="13 1 126 62" cornerSize="10" fill="solid: ffeeece1" hasStroke="1"
               stroke="2, mitered, butt" strokeColour="solid: ffb0b0ff"/>
  </BACKGROUND>
  <LABEL name="gameLabel" id="41cab853eb009189" memberName="gameLabel"
         virtualName="" explicitFocusOrder="0" pos="12 0 128 24" edTextCol="ff000000"
         edBkgCol="0" labelText="Game Name" editableSingleClick="1" editableDoubleClick="1"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="1" italic="0" justification="36"/>
  <LABEL name="addressLabel" id="492e7e3628b82fa6" memberName="addressLabel"
         virtualName="" explicitFocusOrder="0" pos="12 20 128 24" edTextCol="ff000000"
         edBkgCol="0" labelText="127.0.0.1" editableSingleClick="1" editableDoubleClick="1"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="36"/>
  <LABEL name="portLabel" id="fdb2b92f6a085db5" memberName="portLabel"
         virtualName="" explicitFocusOrder="0" pos="12 40 128 24" edTextCol="ff000000"
         edBkgCol="0" labelText="5679" editableSingleClick="1" editableDoubleClick="1"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="36"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif


//[EndFile] You can add extra defines here...
//[/EndFile]
